
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    laura_hours = model.addVar(lb=0, name="laura_hours")
    peggy_hours = model.addVar(lb=0, name="peggy_hours")
    bill_hours = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="bill_hours")

    # Set objective function
    obj = 9*laura_hours**2 + 2*laura_hours*peggy_hours + 3*laura_hours*bill_hours + 9*peggy_hours**2 + 8*peggy_hours*bill_hours + 9*bill_hours**2 + 3*laura_hours + 2*peggy_hours + 9*bill_hours
    model.setObjective(obj, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(7*laura_hours + 14*bill_hours >= 20, "c1")
    model.addConstr(7*laura_hours + 6*peggy_hours + 14*bill_hours >= 30, "c2")
    model.addConstr(3*peggy_hours + 2*bill_hours <= 92, "c3")
    model.addConstr(6*laura_hours + 3*peggy_hours <= 100, "c4")
    model.addConstr(6*laura_hours + 3*peggy_hours + 2*bill_hours <= 100, "c5")
    model.addConstr(6*peggy_hours + 14*bill_hours <= 121, "c6")
    model.addConstr(7*laura_hours + 6*peggy_hours + 14*bill_hours <= 76, "c7")
    model.addConstr(7*laura_hours + 6*peggy_hours + 14*bill_hours <= 76, "c8")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Laura Hours: %g' % laura_hours.x)
        print('Peggy Hours: %g' % peggy_hours.x)
        print('Bill Hours: %g' % bill_hours.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ": " + str(e))

except AttributeError:
    print('Encountered an attribute error')
