
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(lb=0, name="hours_worked_by_Laura", vtype=gurobi.GRB.CONTINUOUS)
x1 = m.addVar(lb=0, name="hours_worked_by_Peggy", vtype=gurobi.GRB.CONTINUOUS)
x2 = m.addVar(lb=0, name="hours_worked_by_Bill", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(9*x0**2 + 2*x0*x1 + 3*x0*x2 + 9*x1**2 + 8*x1*x2 + 9*x2**2 + 3*x0 + 2*x1 + 9*x2, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(6*x0 == 6)
m.addConstr(7*x0 <= 178)
m.addConstr(3*x1 == 3)
m.addConstr(6*x1 <= 178)
m.addConstr(2*x2 == 2)
m.addConstr(14*x2 <= 178)
m.addConstr(7*x0 + 14*x2 >= 20)
m.addConstr(7*x0 + 6*x1 + 14*x2 >= 30)
m.addConstr(3*x1 + 2*x2 <= 92)
m.addConstr(6*x0 + 3*x1 <= 100)
m.addConstr(6*x0 + 3*x1 + 2*x2 <= 100)
m.addConstr(6*x1 + 14*x2 <= 121)
m.addConstr(7*x0 + 6*x1 + 14*x2 <= 76)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
else:
    print("The model is infeasible")
