
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
tomatoes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="tomatoes")
bowls_of_instant_ramen = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="bowls_of_instant_ramen")
bagged_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bagged_salads")
kale_salads = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="kale_salads")


# Set objective function
m.setObjective(3 * tomatoes + 3 * bowls_of_instant_ramen + 8 * bagged_salads + 1 * kale_salads, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(0.32 * tomatoes + 0.58 * bagged_salads >= 33)
m.addConstr(0.32 * tomatoes + 0.04 * kale_salads >= 31)
m.addConstr(1.67 * bowls_of_instant_ramen + 0.04 * kale_salads >= 24)
m.addConstr(0.32 * tomatoes + 1.67 * bowls_of_instant_ramen >= 47)
m.addConstr(1.67 * bowls_of_instant_ramen + 0.58 * bagged_salads >= 44)
m.addConstr(0.32 * tomatoes + 1.67 * bowls_of_instant_ramen + 0.58 * bagged_salads + 0.04 * kale_salads >= 44)
m.addConstr(1.74 * bowls_of_instant_ramen + 0.08 * kale_salads >= 19)
m.addConstr(1.97 * tomatoes + 1.74 * bowls_of_instant_ramen >= 33)
m.addConstr(1.97 * tomatoes + 1.21 * bagged_salads + 0.08 * kale_salads >= 39)
m.addConstr(1.97 * tomatoes + 1.74 * bowls_of_instant_ramen + 1.21 * bagged_salads >= 39)
m.addConstr(1.97 * tomatoes + 1.21 * bagged_salads + 0.08 * kale_salads >= 40)
m.addConstr(1.97 * tomatoes + 1.74 * bowls_of_instant_ramen + 1.21 * bagged_salads >= 40)
m.addConstr(1.97 * tomatoes + 1.74 * bowls_of_instant_ramen + 1.21 * bagged_salads + 0.08 * kale_salads >= 40)
m.addConstr(1.07 * tomatoes + 1.31 * bowls_of_instant_ramen >= 22)
m.addConstr(1.07 * tomatoes + 0.11 * bagged_salads >= 14)
m.addConstr(1.31 * bowls_of_instant_ramen + 1.47 * kale_salads >= 19)
m.addConstr(1.07 * tomatoes + 1.31 * bowls_of_instant_ramen + 1.47 * kale_salads >= 20)
m.addConstr(1.07 * tomatoes + 0.11 * bagged_salads + 1.47 * kale_salads >= 20)
m.addConstr(1.31 * bowls_of_instant_ramen + 0.11 * bagged_salads + 1.47 * kale_salads >= 20)
m.addConstr(1.07 * tomatoes + 1.31 * bowls_of_instant_ramen + 1.47 * kale_salads >= 22)
m.addConstr(1.07 * tomatoes + 0.11 * bagged_salads + 1.47 * kale_salads >= 22)
m.addConstr(1.31 * bowls_of_instant_ramen + 0.11 * bagged_salads + 1.47 * kale_salads >= 22)
m.addConstr(1.07 * tomatoes + 1.31 * bowls_of_instant_ramen + 1.47 * kale_salads >= 14)
m.addConstr(1.07 * tomatoes + 0.11 * bagged_salads + 1.47 * kale_salads >= 14)
m.addConstr(1.31 * bowls_of_instant_ramen + 0.11 * bagged_salads + 1.47 * kale_salads >= 14)
m.addConstr(1.07 * tomatoes + 1.31 * bowls_of_instant_ramen + 0.11 * bagged_salads + 1.47 * kale_salads >= 14)
m.addConstr(-8 * bowls_of_instant_ramen + 7 * bagged_salads >= 0)
m.addConstr(-1 * tomatoes + 6 * bowls_of_instant_ramen + 2 * bagged_salads >= 0)
m.addConstr(0.32 * tomatoes + 0.04 * kale_salads <= 58)
m.addConstr(1.67 * bowls_of_instant_ramen + 0.58 * bagged_salads <= 174)
m.addConstr(0.58 * bagged_salads + 0.04 * kale_salads <= 68)
m.addConstr(0.32 * tomatoes + 1.67 * bowls_of_instant_ramen <= 115)
m.addConstr(0.32 * tomatoes + 0.58 * bagged_salads + 0.04 * kale_salads <= 79)
m.addConstr(1.97 * tomatoes + 0.08 * kale_salads <= 59)
m.addConstr(1.97 * tomatoes + 1.21 * bagged_salads <= 139)
m.addConstr(1.74 * bowls_of_instant_ramen + 1.21 * bagged_salads <= 48)
m.addConstr(1.97 * tomatoes + 1.74 * bowls_of_instant_ramen <= 47)
m.addConstr(1.97 * tomatoes + 1.74 * bowls_of_instant_ramen + 1.21 * bagged_salads <= 140)
m.addConstr(1.97 * tomatoes + 1.21 * bagged_salads + 0.08 * kale_salads <= 70)
m.addConstr(1.07 * tomatoes + 0.11 * bagged_salads + 1.47 * kale_salads <= 39)
m.addConstr(1.31 * bowls_of_instant_ramen + 0.11 * bagged_salads + 1.47 * kale_salads <= 64)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

