
import gurobipy as gp

# Create a new model
model = gp.Model("food_optimization")

# Create variables
cheeseburgers = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cheeseburgers")
oreos = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oreos")
bananas = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bananas")

# Set objective function
model.setObjective(3 * cheeseburgers + 3 * oreos + 1 * bananas, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(1 * cheeseburgers + 2 * oreos >= 8, "protein_constraint1")
model.addConstr(3 * oreos + 5 * bananas >= 46, "tastiness_constraint1")
model.addConstr(8 * cheeseburgers + 5 * bananas >= 35, "tastiness_constraint2")
model.addConstr(1 * cheeseburgers + 7 * bananas <= 60, "protein_constraint2")
model.addConstr(1 * cheeseburgers + 2 * oreos <= 47, "protein_constraint3")
model.addConstr(1 * cheeseburgers + 2 * oreos + 7 * bananas <= 47, "protein_constraint4")
model.addConstr(3 * oreos + 5 * bananas <= 113, "tastiness_constraint3")
model.addConstr(8 * cheeseburgers + 5 * bananas <= 105, "tastiness_constraint4")
model.addConstr(8 * cheeseburgers + 3 * oreos + 5 * bananas <= 105, "tastiness_constraint5")


# Add upper bound constraints based on resources
model.addConstr(1 * cheeseburgers <= 68, "protein_resource_constraint")
model.addConstr(8 * cheeseburgers <= 156, "tastiness_resource_constraint")



# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Cheeseburgers: {cheeseburgers.x}")
    print(f"Oreos: {oreos.x}")
    print(f"Bananas: {bananas.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

