
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="cheeseburgers", lb=0)  # No lower bound specified, assuming 0
    x1 = model.addVar(name="oreos", lb=0)  # No lower bound specified, assuming 0
    x2 = model.addVar(name="bananas", lb=0)  # No lower bound specified, assuming 0

    # Define the objective function
    model.setObjective(3*x0 + 3*x1 + x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x0 + 2*x1 >= 8)
    model.addConstr(3*x1 + 5*x2 >= 46)
    model.addConstr(8*x0 + 5*x2 >= 35)
    model.addConstr(x0 + 7*x2 <= 60)
    model.addConstr(x0 + 2*x1 <= 47)
    model.addConstr(x0 + 2*x1 + 7*x2 <= 47)
    model.addConstr(3*x1 + 5*x2 <= 113)
    model.addConstr(8*x0 + 5*x2 <= 105)
    model.addConstr(8*x0 + 3*x1 + 5*x2 <= 105)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Cheeseburgers: {x0.varValue}")
        print(f"Oreos: {x1.varValue}")
        print(f"Bananas: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
