
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
x = m.addVars(5, lb=0, vtype=gp.GRB.CONTINUOUS, name=["peanutbutter sandwiches", "steaks", "rotisserie chickens", "corn cobs", "protein bars"])


# Set objective function
m.setObjective(5*x[0] + 1*x[1] + 3*x[2] + 4*x[3] + 5*x[4], gp.GRB.MINIMIZE)

# Add constraints

tastiness = {0: 5, 1: 14, 2: 2, 3: 14, 4: 7}
sourness = {0: 12, 1: 8, 2: 10, 3: 1, 4: 2}
fiber = {0: 14, 1: 8, 2: 11, 3: 1, 4: 7}
protein = {0: 12, 1: 11, 2: 2, 3: 7, 4: 14}

m.addConstr(gp.quicksum(tastiness[i] * x[i] for i in range(5)) <= 269, "tastiness_ub")
m.addConstr(gp.quicksum(sourness[i] * x[i] for i in range(5)) <= 234, "sourness_ub")
m.addConstr(gp.quicksum(fiber[i] * x[i] for i in range(5)) <= 146, "fiber_ub")
m.addConstr(gp.quicksum(protein[i] * x[i] for i in range(5)) <= 157, "protein_ub")


m.addConstr(2*x[2] + 7*x[4] >= 32)
m.addConstr(14*x[1] + 14*x[3] >= 43)
m.addConstr(14*x[1] + 7*x[4] >= 48)
m.addConstr(5*x[0] + 14*x[3] >= 33)
m.addConstr(2*x[2] + 14*x[3] >= 48)
m.addConstr(14*x[3] + 7*x[4] >= 32)
m.addConstr(5*x[0] + 2*x[2] >= 26)
m.addConstr(14*x[1] + 2*x[2] >= 50)
m.addConstr(5*x[0] + 14*x[1] >= 18)
# ... (rest of the constraints as generated in the JSON, using the dictionaries for coefficients)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

