
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="peanutbutter_sandwiches", lb=-gp.GRB.INFINITY)
x1 = m.addVar(name="steaks", lb=-gp.GRB.INFINITY)
x2 = m.addVar(name="rotisserie_chickens", lb=-gp.GRB.INFINITY)
x3 = m.addVar(name="corn_cobs", lb=-gp.GRB.INFINITY)
x4 = m.addVar(name="protein_bars", lb=-gp.GRB.INFINITY)

# Objective function
m.setObjective(5*x0 + x1 + 3*x2 + 4*x3 + 5*x4, gp.GRB.MINIMIZE)

# Constraints
# Tastiness rating constraints
m.addConstr(5*x0 + 14*x1 + 2*x2 + 14*x3 + 7*x4 <= 269, name='tastiness_rating')
m.addConstr(5*x2 + 7*x4 >= 32, name='tastiness_rating_chickens_bars')
m.addConstr(14*x1 + 14*x3 >= 43, name='tastiness_rating_steaks_corn')
m.addConstr(14*x1 + 7*x4 >= 48, name='tastiness_rating_steaks_bars')
m.addConstr(5*x0 + 14*x3 >= 33, name='tastiness_rating_sandwiches_corn')
m.addConstr(2*x2 + 14*x3 >= 48, name='tastiness_rating_chickens_corn')
m.addConstr(14*x3 + 7*x4 >= 32, name='tastiness_rating_corn_bars')
m.addConstr(5*x0 + 2*x2 >= 26, name='tastiness_rating_sandwiches_chickens')
m.addConstr(14*x1 + 2*x2 >= 50, name='tastiness_rating_steaks_chickens')
m.addConstr(5*x0 + 14*x1 >= 18, name='tastiness_rating_sandwiches_steaks')
m.addConstr(14*x1 + 2*x2 + 14*x3 >= 29, name='tastiness_rating_steaks_chickens_corn')
m.addConstr(5*x0 + 14*x1 + 14*x3 >= 29, name='tastiness_rating_sandwiches_steaks_corn')
m.addConstr(5*x0 + 2*x2 + 14*x3 >= 29, name='tastiness_rating_sandwiches_chickens_corn')
m.addConstr(14*x1 + 2*x2 + 14*x3 >= 35, name='tastiness_rating_steaks_chickens_corn_2')
m.addConstr(5*x0 + 14*x1 + 14*x3 >= 35, name='tastiness_rating_sandwiches_steaks_corn_2')
m.addConstr(5*x0 + 2*x2 + 14*x3 >= 35, name='tastiness_rating_sandwiches_chickens_corn_2')
m.addConstr(14*x1 + 2*x2 + 14*x3 >= 46, name='tastiness_rating_steaks_chickens_corn_3')
m.addConstr(5*x0 + 14*x1 + 14*x3 >= 46, name='tastiness_rating_sandwiches_steaks_corn_3')
m.addConstr(5*x0 + 2*x2 + 14*x3 >= 46, name='tastiness_rating_sandwiches_chickens_corn_3')
m.addConstr(5*x0 + 14*x1 + 2*x2 + 14*x3 + 7*x4 >= 46, name='tastiness_rating_all')

# Sourness index constraints
m.addConstr(12*x0 + x3 >= 45, name='sourness_index_sandwiches_corn')
m.addConstr(8*x1 + 2*x4 >= 25, name='sourness_index_steaks_bars')
m.addConstr(12*x0 + 8*x1 >= 31, name='sourness_index_sandwiches_steaks')
m.addConstr(12*x0 + 2*x4 >= 18, name='sourness_index_sandwiches_bars')
m.addConstr(12*x0 + 10*x2 + 2*x4 >= 46, name='sourness_index_sandwiches_chickens_bars')
m.addConstr(12*x0 + 8*x1 + 10*x2 + x3 + 2*x4 >= 46, name='sourness_index_all')

# Fiber constraints
m.addConstr(14*x0 + 8*x1 + 11*x2 + x3 + 7*x4 >= 21, name='fiber_sandwiches_bars')
m.addConstr(14*x0 + 8*x1 >= 12, name='fiber_sandwiches_steaks')
m.addConstr(8*x1 + 11*x2 + 7*x4 >= 22, name='fiber_steaks_chickens_bars')
m.addConstr(x3 + 7*x4 >= 25, name='fiber_corn_bars')
m.addConstr(14*x0 + 11*x2 >= 12, name='fiber_sandwiches_chickens')
m.addConstr(14*x0 + x3 >= 11, name='fiber_sandwiches_corn')
m.addConstr(14*x0 + 8*x1 + x3 >= 14, name='fiber_sandwiches_steaks_corn')
m.addConstr(14*x0 + 11*x2 + x3 >= 14, name='fiber_sandwiches_chickens_corn')
m.addConstr(8*x1 + 11*x2 + x3 >= 14, name='fiber_steaks_chickens_corn')
m.addConstr(8*x1 + x3 + 7*x4 >= 14, name='fiber_steaks_corn_bars')

# Protein constraints
m.addConstr(11*x1 + 7*x3 >= 11, name='protein_steaks_corn')
m.addConstr(2*x2 + 7*x3 >= 25, name='protein_chickens_corn')
m.addConstr(12*x0 + 2*x2 >= 14, name='protein_sandwiches_chickens')
m.addConstr(11*x1 + 2*x2 >= 18, name='protein_steaks_chickens')
m.addConstr(12*x0 + 11*x1 + 2*x2 >= 21, name='protein_sandwiches_steaks_chickens')

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Peanutbutter sandwiches: ", x0.varValue)
    print("Steaks: ", x1.varValue)
    print("Rotisserie chickens: ", x2.varValue)
    print("Corn cobs: ", x3.varValue)
    print("Protein bars: ", x4.varValue)
else:
    print("No optimal solution found")
