
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=GRB.INTEGER, name="hours worked by Dale")
    x1 = model.addVar(vtype=GRB.INTEGER, name="hours worked by Laura")
    x2 = model.addVar(vtype=GRB.INTEGER, name="hours worked by Bobby")


    # Set objective function
    model.setObjective(1*x0 + 8*x1 + 7*x2, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(3*x0 + 6*x2 >= 8, "c1")
    model.addConstr(7*x1 + 6*x2 >= 20, "c2")
    model.addConstr(3*x0 + 7*x1 + 6*x2 >= 20, "c3")
    model.addConstr(9*x0 + 3*x1 >= 31, "c4")
    model.addConstr(9*x0 + 3*x1 + 2*x2 >= 31, "c5")
    model.addConstr(6*x0 - 4*x1 >= 0, "c6")
    model.addConstr(-9*x1 + 4*x2 >= 0, "c7")
    model.addConstr(3*x0 + 6*x2 <= 27, "c8")
    model.addConstr(3*x0 + 7*x1 <= 68, "c9")
    model.addConstr(7*x1 + 6*x2 <= 45, "c10")
    model.addConstr(9*x0 + 3*x1 + 2*x2 <= 77, "c11")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
