
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="hours_worked_by_Dale", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="hours_worked_by_Laura", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="hours_worked_by_Bobby", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(x0 + 8 * x1 + 7 * x2, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(3 * x0 <= 77)
m.addConstr(9 * x0 <= 112)
m.addConstr(7 * x1 <= 77)
m.addConstr(3 * x1 <= 112)
m.addConstr(6 * x2 <= 77)
m.addConstr(2 * x2 <= 112)
m.addConstr(3 * x0 + 6 * x2 >= 8)
m.addConstr(7 * x1 + 6 * x2 >= 20)
m.addConstr(3 * x0 + 7 * x1 + 6 * x2 >= 20)
m.addConstr(9 * x0 + 3 * x1 >= 31)
m.addConstr(9 * x0 + 3 * x1 + 2 * x2 >= 31)
m.addConstr(6 * x0 - 4 * x1 >= 0)
m.addConstr(-9 * x1 + 4 * x2 >= 0)
m.addConstr(3 * x0 + 6 * x2 <= 27)
m.addConstr(3 * x0 + 7 * x1 <= 68)
m.addConstr(7 * x1 + 6 * x2 <= 45)
m.addConstr(9 * x0 + 3 * x1 + 2 * x2 <= 77)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Dale: {x0.varValue}")
    print(f"Hours worked by Laura: {x1.varValue}")
    print(f"Hours worked by Bobby: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
