
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    hank = model.addVar(vtype=gp.GRB.INTEGER, name="hank")
    ringo = model.addVar(vtype=gp.GRB.INTEGER, name="ringo")
    paul = model.addVar(vtype=gp.GRB.INTEGER, name="paul")
    laura = model.addVar(vtype=gp.GRB.INTEGER, name="laura")

    # Set objective function
    model.setObjective(9.01 * hank + 2.2 * ringo + 5.01 * paul + 4.0 * laura, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(2 * hank + 13 * ringo + 13 * paul + 8 * laura <= 130, "c0")
    model.addConstr(13 * ringo + 8 * laura >= 23, "c1")
    model.addConstr(2 * hank + 13 * paul >= 22, "c2")
    model.addConstr(2 * hank + 8 * laura >= 10, "c3")
    model.addConstr(13 * ringo + 13 * paul + 8 * laura >= 19, "c4")
    model.addConstr(2 * hank + 8 * laura <= 101, "c5")
    model.addConstr(13 * paul + 8 * laura <= 74, "c6")
    model.addConstr(2 * hank + 13 * paul <= 86, "c7")
    model.addConstr(2 * hank + 13 * ringo <= 120, "c8")
    model.addConstr(13 * ringo + 8 * laura <= 91, "c9")
    model.addConstr(13 * ringo + 13 * paul <= 119, "c10")
    model.addConstr(2 * hank + 13 * ringo + 8 * laura <= 47, "c11")
    model.addConstr(13 * ringo + 13 * paul + 8 * laura <= 90, "c12")
    model.addConstr(2 * hank + 13 * ringo + 13 * paul + 8 * laura <= 90, "c13")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
