
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="x1", vtype=gp.GRB.INTEGER)  # hours worked by Hank
x2 = m.addVar(name="x2", vtype=gp.GRB.INTEGER)  # hours worked by Ringo
x3 = m.addVar(name="x3", vtype=gp.GRB.INTEGER)  # hours worked by Paul
x4 = m.addVar(name="x4", vtype=gp.GRB.INTEGER)  # hours worked by Laura

# Define the objective function
m.setObjective(9.01 * x1 + 2.2 * x2 + 5.01 * x3 + 4.0 * x4, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * x1 <= 130)
m.addConstr(13 * x2 <= 130)
m.addConstr(13 * x3 <= 130)
m.addConstr(8 * x4 <= 130)

m.addConstr(13 * x2 + 8 * x4 >= 23)
m.addConstr(2 * x1 + 13 * x3 >= 22)
m.addConstr(2 * x1 + 8 * x4 >= 10)
m.addConstr(13 * x2 + 13 * x3 + 8 * x4 >= 19)

m.addConstr(2 * x1 + 8 * x4 <= 101)
m.addConstr(13 * x3 + 8 * x4 <= 74)
m.addConstr(2 * x1 + 13 * x3 <= 86)
m.addConstr(2 * x1 + 13 * x2 <= 120)
m.addConstr(13 * x2 + 8 * x4 <= 91)
m.addConstr(13 * x2 + 13 * x3 <= 119)

m.addConstr(2 * x1 + 13 * x2 + 8 * x4 <= 47)
m.addConstr(13 * x2 + 13 * x3 + 8 * x4 <= 90)
m.addConstr(2 * x1 + 13 * x2 + 13 * x3 + 8 * x4 <= 90)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Hank: ", x1.varValue)
    print("Hours worked by Ringo: ", x2.varValue)
    print("Hours worked by Paul: ", x3.varValue)
    print("Hours worked by Laura: ", x4.varValue)
else:
    print("The problem is infeasible")
