
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
iron = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="iron")
vitamin_b2 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_b2")
potassium = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="potassium")
vitamin_b4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b4")
fiber = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fiber")


# Set objective function
m.setObjective(2*iron + 5*vitamin_b2 + 5*potassium + 2*vitamin_b4 + 4*fiber, gp.GRB.MAXIMIZE)

# Add constraints

# Resource constraints
m.addConstr(3*iron + 3*vitamin_b2 + 6*potassium + 6*vitamin_b4 + 6*fiber <= 153, "cognitive_performance")
m.addConstr(8*iron + 2*vitamin_b2 + 4*potassium + 5*vitamin_b4 + 1*fiber <= 88, "digestive_support")


# ... (The rest of the constraints from the JSON "constraints" section are added here similarly)
# Example:
# m.addConstr(3*iron + 6*vitamin_b4 >= 29)
# ...


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('iron:', iron.x)
    print('vitamin_b2:', vitamin_b2.x)
    print('potassium:', potassium.x)
    print('vitamin_b4:', vitamin_b4.x)
    print('fiber:', fiber.x)

elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

