
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
x = {}
var_names = ["medical platoons", "transportation companies", "military intelligence companies", "logistics companies", "signal platoons"]
for i in range(len(var_names)):
    x[i] = m.addVar(vtype=gp.GRB.INTEGER, name=var_names[i])


# Set objective function
obj_coeffs = [4.98, 8.23, 1.79, 7.38, 4.81]
m.setObjective(gp.quicksum(obj_coeffs[i] * x[i] for i in range(len(var_names))), gp.GRB.MINIMIZE)

# Add constraints
fun_factor = [17, 2, 12, 13, 5]
logistical_capacity = [17, 2, 3, 18, 8]

m.addConstr(12 * x[2] + 13 * x[3] >= 36)
m.addConstr(17 * x[0] + 5 * x[4] >= 26)
m.addConstr(13 * x[3] + 5 * x[4] >= 27)
m.addConstr(2 * x[1] + 5 * x[4] >= 31)
m.addConstr(2 * x[1] + 12 * x[2] >= 54)
m.addConstr(17 * x[0] + 12 * x[2] + 5 * x[4] >= 30)
m.addConstr(2 * x[1] + 13 * x[3] + 5 * x[4] >= 30)
m.addConstr(17 * x[0] + 12 * x[2] + 5 * x[4] >= 44)
m.addConstr(2 * x[1] + 13 * x[3] + 5 * x[4] >= 44)
m.addConstr(17 * x[0] + 2 * x[1] + 12 * x[2] + 13 * x[3] + 5 * x[4] >= 44)
m.addConstr(17 * x[0] + 2 * x[1] >= 40)
m.addConstr(17 * x[0] + 18 * x[3] >= 30)
m.addConstr(2 * x[1] + 3 * x[2] >= 40)
m.addConstr(18 * x[3] + 8 * x[4] >= 18)
m.addConstr(17 * x[0] + 8 * x[4] >= 30)
m.addConstr(2 * x[1] + 8 * x[4] >= 46)
m.addConstr(17 * x[0] + 3 * x[2] >= 38)
m.addConstr(17 * x[0] + 2 * x[1] + 18 * x[3] >= 44)
m.addConstr(2 * x[1] + 3 * x[2] + 8 * x[4] >= 44)
m.addConstr(17 * x[0] + 2 * x[1] + 3 * x[2] >= 44)
m.addConstr(17 * x[0] + 2 * x[1] + 18 * x[3] >= 43)
m.addConstr(2 * x[1] + 3 * x[2] + 8 * x[4] >= 43)
m.addConstr(17 * x[0] + 2 * x[1] + 3 * x[2] >= 43)
m.addConstr(17 * x[0] + 2 * x[1] + 18 * x[3] >= 37)
m.addConstr(2 * x[1] + 3 * x[2] + 8 * x[4] >= 37)
m.addConstr(17 * x[0] + 2 * x[1] + 3 * x[2] >= 37)
m.addConstr(17 * x[0] + 2 * x[1] + 3 * x[2] + 18 * x[3] + 8 * x[4] >= 37)
m.addConstr(10 * x[0] - 7 * x[1] >= 0)
m.addConstr(3 * x[3] - x[4] >= 0)
m.addConstr(x[0] + 5 * x[2] - 2 * x[3] >= 0)
m.addConstr(17 * x[0] + 5 * x[4] <= 244)
m.addConstr(2 * x[1] + 13 * x[3] <= 263)
m.addConstr(17 * x[0] + 13 * x[3] <= 68)
m.addConstr(17 * x[0] + 2 * x[1] + 5 * x[4] <= 206)
m.addConstr(17 * x[0] + 2 * x[1] + 12 * x[2] <= 93)
m.addConstr(2 * x[1] + 13 * x[3] + 5 * x[4] <= 143)
m.addConstr(12 * x[2] + 13 * x[3] + 5 * x[4] <= 172)
m.addConstr(17 * x[0] + 12 * x[2] + 13 * x[3] <= 243)
m.addConstr(2 * x[1] + 3 * x[2] <= 144)
m.addConstr(17 * x[0] + 8 * x[4] <= 125)
m.addConstr(3 * x[2] + 18 * x[3] <= 164)
m.addConstr(18 * x[3] + 8 * x[4] <= 116)
m.addConstr(17 * x[0] + 18 * x[3] <= 184)
m.addConstr(17 * x[0] + 2 * x[1] <= 207)
m.addConstr(2 * x[1] + 18 * x[3] <= 63)
m.addConstr(17 * x[0] + 3 * x[2] <= 187)
m.addConstr(3 * x[2] + 8 * x[4] <= 227)
m.addConstr(3 * x[2] + 18 * x[3] + 8 * x[4] <= 85)
m.addConstr(17 * x[0] + 18 * x[3] + 8 * x[4] <= 129)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
    print(f'Objective Value: {m.objVal}')
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

