
import gurobi

def optimize_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="medical_platoons", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="transportation_companies", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="military_intelligence_companies", vtype=gurobi.GRB.INTEGER)
    x4 = model.addVar(name="logistics_companies", vtype=gurobi.GRB.INTEGER)
    x5 = model.addVar(name="signal_platoons", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(4.98*x1 + 8.23*x2 + 1.79*x3 + 7.38*x4 + 4.81*x5, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(12*x3 + 13*x4 >= 36)
    model.addConstr(17*x1 + 5*x5 >= 26)
    model.addConstr(13*x4 + 5*x5 >= 27)
    model.addConstr(2*x2 + 5*x5 >= 31)
    model.addConstr(12*x3 + 2*x2 >= 54)
    model.addConstr(17*x1 + 12*x3 + 5*x5 >= 30)
    model.addConstr(2*x2 + 13*x4 + 5*x5 >= 30)
    model.addConstr(17*x1 + 12*x3 + 5*x5 >= 44)
    model.addConstr(2*x2 + 13*x4 + 5*x5 >= 44)
    model.addConstr(17*x1 + 2*x2 + 12*x3 + 13*x4 + 5*x5 >= 44)
    model.addConstr(17*x1 + 2*x2 >= 40)
    model.addConstr(17*x1 + 18*x4 >= 30)
    model.addConstr(2*x2 + 3*x3 >= 40)
    model.addConstr(18*x4 + 8*x5 >= 18)
    model.addConstr(17*x1 + 8*x5 >= 30)
    model.addConstr(2*x2 + 8*x5 >= 46)
    model.addConstr(17*x1 + 3*x3 >= 38)
    model.addConstr(17*x1 + 2*x2 + 18*x4 >= 44)
    model.addConstr(2*x2 + 3*x3 + 8*x5 >= 44)
    model.addConstr(17*x1 + 2*x2 + 3*x3 >= 44)
    model.addConstr(17*x1 + 2*x2 + 18*x4 >= 43)
    model.addConstr(2*x2 + 3*x3 + 8*x5 >= 43)
    model.addConstr(17*x1 + 2*x2 + 3*x3 >= 43)
    model.addConstr(17*x1 + 2*x2 + 18*x4 >= 37)
    model.addConstr(2*x2 + 3*x3 + 8*x5 >= 37)
    model.addConstr(17*x1 + 2*x2 + 3*x3 >= 37)
    model.addConstr(17*x1 + 2*x2 + 3*x3 + 18*x4 + 8*x5 >= 37)
    model.addConstr(10*x1 - 7*x2 >= 0)
    model.addConstr(3*x4 - x5 >= 0)
    model.addConstr(x1 + 5*x3 - 2*x4 >= 0)
    model.addConstr(17*x1 + 5*x5 <= 244)
    model.addConstr(2*x2 + 13*x4 <= 263)
    model.addConstr(17*x1 + 13*x4 <= 68)
    model.addConstr(17*x1 + 2*x2 + 5*x5 <= 206)
    model.addConstr(17*x1 + 2*x2 + 12*x3 <= 93)
    model.addConstr(2*x2 + 13*x4 + 5*x5 <= 143)
    model.addConstr(12*x3 + 13*x4 + 5*x5 <= 172)
    model.addConstr(17*x1 + 12*x3 + 13*x4 <= 243)
    model.addConstr(2*x2 + 3*x3 <= 144)
    model.addConstr(17*x1 + 8*x5 <= 125)
    model.addConstr(3*x3 + 18*x4 <= 164)
    model.addConstr(18*x4 + 8*x5 <= 116)
    model.addConstr(17*x1 + 18*x4 <= 184)
    model.addConstr(17*x1 + 2*x2 <= 207)
    model.addConstr(2*x2 + 18*x4 <= 63)
    model.addConstr(17*x1 + 3*x3 <= 187)
    model.addConstr(3*x3 + 8*x5 <= 227)
    model.addConstr(3*x3 + 18*x4 + 8*x5 <= 85)
    model.addConstr(17*x1 + 18*x4 + 8*x5 <= 129)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Medical platoons: ", x1.varValue)
        print("Transportation companies: ", x2.varValue)
        print("Military intelligence companies: ", x3.varValue)
        print("Logistics companies: ", x4.varValue)
        print("Signal platoons: ", x5.varValue)
    else:
        print("No optimal solution found")

optimize_problem()
