
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0")
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1")
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2")


    # Set objective function
    m.setObjective(1*x0 + 5*x1 + 2*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(20*x0 + 6*x2 >= 71)
    m.addConstr(2*x1 + 6*x2 >= 34)
    m.addConstr(20*x0 + 2*x1 + 6*x2 >= 34)
    m.addConstr(9*x0 + 19*x2 >= 105)
    m.addConstr(6*x1 + 19*x2 >= 99)
    m.addConstr(9*x0 + 6*x1 + 19*x2 >= 99)
    m.addConstr(13*x0 + 22*x1 >= 56)
    m.addConstr(13*x0 + 15*x2 >= 79)
    m.addConstr(22*x1 + 15*x2 >= 90)
    m.addConstr(13*x0 + 22*x1 + 15*x2 >= 90)
    m.addConstr(10*x0 + 14*x1 >= 105)
    m.addConstr(10*x0 + 12*x2 >= 109)
    m.addConstr(14*x1 + 12*x2 >= 54)
    m.addConstr(10*x0 + 14*x1 + 12*x2 >= 88)
    m.addConstr(4*x0 + 8*x2 >= 30)
    m.addConstr(4*x0 + 12*x1 + 8*x2 >= 30)
    m.addConstr(7*x0 - 10*x1 >= 0)
    m.addConstr(-10*x0 + 5*x2 >= 0)
    m.addConstr(9*x0 + 6*x1 <= 273)
    m.addConstr(9*x0 + 19*x2 <= 204)
    m.addConstr(13*x0 + 22*x1 <= 214)
    m.addConstr(22*x1 + 15*x2 <= 190)
    m.addConstr(13*x0 + 22*x1 + 15*x2 <= 211)
    m.addConstr(12*x1 + 8*x2 <= 73)
    m.addConstr(4*x0 + 8*x2 <= 139)
    m.addConstr(4*x0 + 12*x1 + 8*x2 <= 60)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Other optimization status')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
