
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Peggy
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Dale
    x2 = model.addVar(name="x2", lb=0)  # hours worked by John

    # Objective function
    model.setObjective(1 * x0 + 5 * x1 + 2 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(20 * x0 == 20)
    model.addConstr(9 * x0 == 9)
    model.addConstr(13 * x0 == 13)
    model.addConstr(10 * x0 == 10)
    model.addConstr(4 * x0 == 4)
    model.addConstr(2 * x1 == 2)
    model.addConstr(6 * x1 == 6)
    model.addConstr(22 * x1 == 22)
    model.addConstr(14 * x1 == 14)
    model.addConstr(12 * x1 == 12)
    model.addConstr(6 * x2 == 6)
    model.addConstr(19 * x2 == 19)
    model.addConstr(15 * x2 == 15)
    model.addConstr(12 * x2 == 12)
    model.addConstr(8 * x2 == 8)
    model.addConstr(20 * x0 + 6 * x2 >= 71)
    model.addConstr(2 * x1 + 6 * x2 >= 34)
    model.addConstr(20 * x0 + 2 * x1 + 6 * x2 >= 34)
    model.addConstr(9 * x0 + 19 * x2 >= 105)
    model.addConstr(6 * x1 + 19 * x2 >= 99)
    model.addConstr(9 * x0 + 6 * x1 + 19 * x2 >= 99)
    model.addConstr(13 * x0 + 22 * x1 >= 56)
    model.addConstr(13 * x0 + 15 * x2 >= 79)
    model.addConstr(22 * x1 + 15 * x2 >= 90)
    model.addConstr(13 * x0 + 22 * x1 + 15 * x2 >= 90)
    model.addConstr(10 * x0 + 14 * x1 >= 105)
    model.addConstr(10 * x0 + 12 * x2 >= 109)
    model.addConstr(14 * x1 + 12 * x2 >= 54)
    model.addConstr(10 * x0 + 14 * x1 + 12 * x2 >= 88)
    model.addConstr(4 * x0 + 8 * x2 >= 30)
    model.addConstr(4 * x0 + 12 * x1 + 8 * x2 >= 30)
    model.addConstr(7 * x0 - 10 * x1 >= 0)
    model.addConstr(-10 * x0 + 5 * x2 >= 0)
    model.addConstr(9 * x0 + 6 * x1 <= 273)
    model.addConstr(9 * x0 + 19 * x2 <= 204)
    model.addConstr(13 * x0 + 22 * x1 <= 214)
    model.addConstr(22 * x1 + 15 * x2 <= 190)
    model.addConstr(13 * x0 + 22 * x1 + 15 * x2 <= 211)
    model.addConstr(12 * x1 + 8 * x2 <= 73)
    model.addConstr(4 * x0 + 8 * x2 <= 139)
    model.addConstr(4 * x0 + 12 * x1 + 8 * x2 <= 60)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print("Hours worked by Peggy:", x0.varValue)
        print("Hours worked by Dale:", x1.varValue)
        print("Hours worked by John:", x2.varValue)
        print("Objective function value:", model.objVal)
    else:
        print("No optimal solution found.")

solve_optimization_problem()
