
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("minimize_hours")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # hours worked by Peggy
    x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # hours worked by John
    x2 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2") # hours worked by Dale
    x3 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3") # hours worked by Bill


    # Set objective function
    model.setObjective(9*x0 + 7*x1 + 4*x2 + 5*x3, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(2*x2 + 15*x3 >= 14, "c0")
    model.addConstr(11*x0 + 2*x2 >= 20, "c1")
    model.addConstr(1*x1 + 2*x2 >= 17, "c2")
    model.addConstr(11*x0 + 1*x1 + 2*x2 + 15*x3 >= 17, "c3")
    model.addConstr(8*x0 - 4*x1 >= 0, "c4")
    model.addConstr(1*x1 + 15*x3 <= 38, "c5")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
