
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="x1", lb=0)  # hours worked by Peggy
x2 = m.addVar(name="x2", lb=0)  # hours worked by John
x3 = m.addVar(name="x3", lb=0)  # hours worked by Dale
x4 = m.addVar(name="x4", lb=0)  # hours worked by Bill

# Define the objective function
m.setObjective(9 * x1 + 7 * x2 + 4 * x3 + 5 * x4, gp.GRB.MINIMIZE)

# Define the constraints
m.addConstr(2 * x3 + 15 * x4 >= 14)
m.addConstr(11 * x1 + 2 * x3 >= 20)
m.addConstr(x2 + 2 * x3 >= 17)
m.addConstr(11 * x1 + x2 + 2 * x3 + 15 * x4 >= 17)
m.addConstr(8 * x1 - 4 * x2 >= 0)
m.addConstr(x2 + 15 * x4 <= 38)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Peggy: ", x1.varValue)
    print("Hours worked by John: ", x2.varValue)
    print("Hours worked by Dale: ", x3.varValue)
    print("Hours worked by Bill: ", x4.varValue)
else:
    print("The model is infeasible")
