
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
bill = m.addVar(vtype=gp.GRB.INTEGER, name="bill")
ringo = m.addVar(vtype=gp.GRB.INTEGER, name="ringo")
john = m.addVar(vtype=gp.GRB.INTEGER, name="john")
mary = m.addVar(vtype=gp.GRB.INTEGER, name="mary")
george = m.addVar(vtype=gp.GRB.INTEGER, name="george")
paul = m.addVar(vtype=gp.GRB.INTEGER, name="paul")
bobby = m.addVar(vtype=gp.GRB.INTEGER, name="bobby")


# Set objective
m.setObjective(1 * bill + 4 * ringo + 1 * john + 9 * mary + 3 * george + 7 * paul + 9 * bobby, gp.GRB.MAXIMIZE)

# Add resource constraints
r0_ub = 502
r1_ub = 420

# Add other constraints from the problem description
m.addConstr(4 * paul + 6 * bobby >= 59)
m.addConstr(11 * george + 4 * paul >= 29)
# ... (add all other constraints similarly)


# Add resource constraints based on the provided resource dictionary
resources = {
    'r0': {'description': 'organization score', 'upper_bound': 502, 'x0': 9, 'x1': 10, 'x2': 4, 'x3': 3, 'x4': 11, 'x5': 4, 'x6': 6},
    'r1': {'description': 'paperwork competence rating', 'upper_bound': 420, 'x0': 8, 'x1': 14, 'x2': 4, 'x3': 13, 'x4': 14, 'x5': 9, 'x6': 11}
}

variables = [bill, ringo, john, mary, george, paul, bobby]

for resource_name, resource_data in resources.items():
    expr = gp.LinExpr()
    for i, var in enumerate(variables):
        expr += resource_data[f'x{i}'] * var
    m.addConstr(expr <= resource_data['upper_bound'], resource_name)


# Optimize model
m.optimize()

# Print solution or infeasibility message
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print(f"Optimization ended with status {m.status}")

