
import gurobipy as gp

# Create a new model
model = gp.Model("office_supplies")

# Create variables
x0 = model.addVar(vtype=gp.GRB.INTEGER, name="black_pens")
x1 = model.addVar(vtype=gp.GRB.INTEGER, name="headsets")
x2 = model.addVar(vtype=gp.GRB.INTEGER, name="mechanical_pencils")
x3 = model.addVar(vtype=gp.GRB.INTEGER, name="lanyards")


# Set objective function
model.setObjective(4*x0 + 4*x1 + 8*x2 + 9*x3, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(20*x1 + 2*x3 >= 51, "c1")
model.addConstr(9*x0 + 20*x1 + 10*x2 >= 90, "c2")
model.addConstr(9*x0 + 20*x1 + 10*x2 + 2*x3 >= 90, "c3")
model.addConstr(16*x1 + 7*x3 >= 28, "c4")
model.addConstr(16*x1 + 17*x2 >= 45, "c5")
model.addConstr(17*x2 + 7*x3 >= 66, "c6")
model.addConstr(10*x0 + 16*x1 + 17*x2 + 7*x3 >= 66, "c7")
model.addConstr(16*x0 + 9*x3 >= 73, "c8")
model.addConstr(16*x0 + 1*x2 >= 72, "c9")
model.addConstr(16*x0 + 12*x1 >= 56, "c10")
model.addConstr(12*x1 + 1*x2 >= 62, "c11")
model.addConstr(16*x0 + 12*x1 + 1*x2 + 9*x3 >= 62, "c12")
model.addConstr(-7*x0 + 3*x1 >= 0, "c13")
model.addConstr(9*x0 + 2*x3 <= 261, "c14")
model.addConstr(10*x2 + 2*x3 <= 341, "c15")
model.addConstr(20*x1 + 2*x3 <= 153, "c16")
model.addConstr(20*x1 + 10*x2 <= 136, "c17")
model.addConstr(9*x0 + 10*x2 <= 100, "c18")
model.addConstr(9*x0 + 20*x1 + 2*x3 <= 182, "c19")
model.addConstr(9*x0 + 20*x1 + 10*x2 <= 208, "c20")
model.addConstr(10*x0 + 17*x2 <= 180, "c21")
model.addConstr(10*x0 + 16*x1 <= 281, "c22")
model.addConstr(10*x0 + 7*x3 <= 197, "c23")
model.addConstr(10*x0 + 16*x1 + 17*x2 <= 107, "c24")
model.addConstr(10*x0 + 16*x1 + 7*x3 <= 216, "c25")
model.addConstr(16*x0 + 9*x3 <= 332, "c26")
model.addConstr(12*x1 + 1*x2 <= 309, "c27")
model.addConstr(16*x0 + 12*x1 <= 235, "c28")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Black pens: {x0.x}")
    print(f"Headsets: {x1.x}")
    print(f"Mechanical pencils: {x2.x}")
    print(f"Lanyards: {x3.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

