
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name='black_pens', vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name='headsets', vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='mechanical_pencils', vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name='lanyards', vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(4*x0 + 4*x1 + 8*x2 + 9*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(20*x1 + 2*x3 >= 51)
    model.addConstr(9*x0 + 20*x1 + 10*x2 >= 90)
    model.addConstr(9*x0 + 20*x1 + 10*x2 + 2*x3 >= 90)
    model.addConstr(16*x1 + 7*x3 >= 28)
    model.addConstr(16*x1 + 17*x2 >= 45)
    model.addConstr(17*x2 + 7*x3 >= 66)
    model.addConstr(10*x0 + 16*x1 + 17*x2 + 7*x3 >= 66)
    model.addConstr(16*x0 + 9*x3 >= 73)
    model.addConstr(16*x0 + x2 >= 72)
    model.addConstr(16*x0 + 12*x1 >= 56)
    model.addConstr(12*x1 + x2 >= 62)
    model.addConstr(16*x0 + 12*x1 + x2 + 9*x3 >= 62)
    model.addConstr(-7*x0 + 3*x1 >= 0)
    model.addConstr(9*x0 + 2*x3 <= 261)
    model.addConstr(10*x2 + 2*x3 <= 341)
    model.addConstr(20*x1 + 2*x3 <= 153)
    model.addConstr(20*x1 + 10*x2 <= 136)
    model.addConstr(9*x0 + 10*x2 <= 100)
    model.addConstr(9*x0 + 20*x1 + 2*x3 <= 182)
    model.addConstr(9*x0 + 20*x1 + 10*x2 <= 208)
    model.addConstr(10*x0 + 17*x2 <= 180)
    model.addConstr(10*x0 + 16*x1 <= 281)
    model.addConstr(10*x0 + 7*x3 <= 197)
    model.addConstr(10*x0 + 16*x1 + 17*x2 <= 107)
    model.addConstr(10*x0 + 16*x1 + 7*x3 <= 216)
    model.addConstr(16*x0 + 9*x3 <= 332)
    model.addConstr(12*x1 + x2 <= 309)
    model.addConstr(16*x0 + 12*x1 <= 235)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objval)
        print('Black pens: ', x0.varValue)
        print('Headsets: ', x1.varValue)
        print('Mechanical pencils: ', x2.varValue)
        print('Lanyards: ', x3.varValue)
    else:
        print('No solution found')

solve_optimization_problem()
