
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    george = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="george")
    peggy = model.addVar(lb=0, vtype=GRB.INTEGER, name="peggy")
    hank = model.addVar(lb=0, vtype=GRB.INTEGER, name="hank")

    # Set objective function
    model.setObjective(7.93 * george + 3.2 * peggy + 4.75 * hank, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(2 * george + 9 * peggy + 7 * hank >= 12, "c0")
    model.addConstr(5 * george + 9 * peggy + 6 * hank >= 25, "c1")
    model.addConstr(9 * george + 6 * peggy >= 10, "c2")
    model.addConstr(9 * george + 3 * hank >= 14, "c3")
    model.addConstr(6 * george - 4 * peggy >= 0, "c4")
    model.addConstr(-10 * peggy + 2 * hank >= 0, "c5")
    model.addConstr(5 * george + 9 * peggy <= 38, "c6")
    model.addConstr(9 * george + 3 * hank <= 31, "c7")
    model.addConstr(6 * peggy + 3 * hank <= 53, "c8")
    model.addConstr(9 * george + 6 * peggy <= 72, "c9")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
