
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="hours_worked_by_George", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x1 = m.addVar(name="hours_worked_by_Peggy", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, integrality=gp.GRB.INTEGER)
x2 = m.addVar(name="hours_worked_by_Hank", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, integrality=gp.GRB.INTEGER)

# Objective function
m.setObjective(7.93*x0 + 3.2*x1 + 4.75*x2, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(2*x0 == 2, name="George_work_quality")
m.addConstr(5*x0 == 5, name="George_paperwork_competence")
m.addConstr(9*x0 == 9, name="George_productivity")

m.addConstr(9*x1 == 9, name="Peggy_work_quality")
m.addConstr(9*x1 == 9, name="Peggy_paperwork_competence")
m.addConstr(6*x1 == 6, name="Peggy_productivity")

m.addConstr(7*x2 == 7, name="Hank_work_quality")
m.addConstr(6*x2 == 6, name="Hank_paperwork_competence")
m.addConstr(3*x2 == 3, name="Hank_productivity")

m.addConstr(9*x1 + 7*x2 >= 12, name="combined_work_quality_Peggy_Hank")
m.addConstr(2*x0 + 9*x1 + 7*x2 >= 12, name="combined_work_quality_all")
m.addConstr(9*x1 + 6*x2 >= 25, name="combined_paperwork_competence_Peggy_Hank")
m.addConstr(5*x0 + 9*x1 + 6*x2 >= 16, name="combined_paperwork_competence_all")

m.addConstr(9*x0 + 6*x1 >= 10, name="combined_productivity_George_Peggy")
m.addConstr(9*x0 + 3*x2 >= 14, name="combined_productivity_George_Hank")
m.addConstr(9*x0 + 6*x1 + 3*x2 >= 14, name="combined_productivity_all")

m.addConstr(6*x0 - 4*x1 >= 0, name="George_Peggy_constraint")
m.addConstr(-10*x1 + 2*x2 >= 0, name="Peggy_Hank_constraint")

m.addConstr(5*x0 + 9*x1 <= 38, name="George_Peggy_paperwork_competence")
m.addConstr(9*x0 + 3*x2 <= 31, name="George_Hank_productivity")
m.addConstr(6*x1 + 3*x2 <= 53, name="Peggy_Hank_productivity")
m.addConstr(9*x0 + 6*x1 <= 72, name="George_Peggy_productivity")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by George: ", x0.varValue)
    print("Hours worked by Peggy: ", x1.varValue)
    print("Hours worked by Hank: ", x2.varValue)
else:
    print("The model is infeasible")
