
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
hank = m.addVar(lb=0, name="hank")
dale = m.addVar(lb=0, name="dale")
jean = m.addVar(lb=0, name="jean")
george = m.addVar(lb=0, name="george")

# Set objective function
m.setObjective(6.35*hank**2 + 9.71*hank*dale + 8.11*hank*jean + 4.03*dale*jean + 7.08*dale*george + 1.55*george**2 + 3.05*hank + 5.16*jean, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(1*hank**2 + 11*jean**2 >= 41)
m.addConstr(6*dale + 11*jean >= 41)
m.addConstr(6*dale + 6*george >= 41)
m.addConstr(1*hank**2 + 6*dale**2 >= 29)
m.addConstr(1*hank**2 + 6*dale**2 + 11*jean**2 >= 26)
m.addConstr(1*hank + 11*jean + 6*george >= 26)
m.addConstr(1*hank + 6*dale + 11*jean >= 43)
m.addConstr(1*hank + 11*jean + 6*george >= 43)
m.addConstr(1*hank + 6*dale + 11*jean + 6*george >= 43)
m.addConstr(23*hank + 11*dale >= 30)
m.addConstr(5*jean + 16*george >= 29)
m.addConstr(23*hank**2 + 5*jean**2 >= 21)
m.addConstr(23*hank + 11*dale + 5*jean + 16*george >= 21)
m.addConstr(22*hank + 2*george >= 26)
m.addConstr(22*hank + 5*dale + 14*jean + 2*george >= 26)
m.addConstr(13*dale + 7*jean >= 47)
m.addConstr(19*hank**2 + 13*dale**2 >= 19)
m.addConstr(7*jean**2 + 22*george**2 >= 39)
m.addConstr(13*dale + 22*george >= 18)
m.addConstr(19*hank + 13*dale + 7*jean + 22*george >= 18)
m.addConstr(1*hank**2 + 11*jean**2 <= 165)
m.addConstr(6*dale**2 + 11*jean**2 + 6*george**2 <= 178)
m.addConstr(23*hank + 11*dale + 16*george <= 137)
m.addConstr(23*hank**2 + 5*jean**2 + 16*george**2 <= 88)
m.addConstr(22*hank + 2*george <= 121)
m.addConstr(14*jean + 2*george <= 144)
m.addConstr(5*dale**2 + 2*george**2 <= 170)
m.addConstr(19*hank**2 + 13*dale**2 + 22*george**2 <= 90)
m.addConstr(13*dale**2 + 7*jean**2 + 22*george**2 <= 55)
m.addConstr(19*hank + 13*dale + 7*jean <= 146)
m.addConstr(19*hank + 7*jean + 22*george <= 129)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

