
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=0, name="x0")
    x1 = model.addVar(lb=0, name="x1")
    x2 = model.addVar(lb=0, name="x2")
    x3 = model.addVar(lb=0, name="x3")

    # Objective function
    model.setObjective(6.35 * x0**2 + 9.71 * x0 * x1 + 8.11 * x0 * x2 + 4.03 * x1 * x2 + 7.08 * x1 * x3 + 1.55 * x3**2 + 3.05 * x0 + 5.16 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x0 <= 204)
    model.addConstr(6 * x1 <= 141)
    model.addConstr(11 * x2 <= 186)
    model.addConstr(6 * x3 <= 210)
    model.addConstr(23 * x0 <= 141)
    model.addConstr(11 * x1 <= 141)
    model.addConstr(5 * x2 <= 186)
    model.addConstr(16 * x3 <= 210)
    model.addConstr(22 * x0 <= 186)
    model.addConstr(5 * x1 <= 186)
    model.addConstr(14 * x2 <= 186)
    model.addConstr(2 * x3 <= 186)
    model.addConstr(19 * x0 <= 210)
    model.addConstr(13 * x1 <= 210)
    model.addConstr(7 * x2 <= 210)
    model.addConstr(22 * x3 <= 210)
    model.addConstr(x0**2 + x2**2 >= 41)
    model.addConstr(6 * x1 + 11 * x2 >= 41)
    model.addConstr(6 * x1 + 6 * x3 >= 41)
    model.addConstr(x0**2 + x1**2 >= 29)
    model.addConstr(x0**2 + x1**2 + x2**2 >= 26)
    model.addConstr(x0 + x2 + x3 >= 26)
    model.addConstr(x0 + x1 + x2 + x3 >= 43)
    model.addConstr(x0 + x2 + x3 >= 43)
    model.addConstr(x0 + x1 + x2 + x3 >= 43)
    model.addConstr(23 * x0 + 11 * x1 >= 30)
    model.addConstr(5 * x2 + 16 * x3 >= 29)
    model.addConstr(23 * x0**2 + 5 * x2**2 >= 21)
    model.addConstr(23 * x0 + 11 * x1 + 5 * x2 + 16 * x3 >= 21)
    model.addConstr(22 * x0 + 2 * x3 >= 26)
    model.addConstr(22 * x0 + 5 * x1 + 14 * x2 + 2 * x3 >= 26)
    model.addConstr(13 * x1 + 7 * x2 >= 47)
    model.addConstr(19 * x0**2 + 13 * x1**2 >= 19)
    model.addConstr(7 * x2**2 + 22 * x3**2 >= 39)
    model.addConstr(13 * x1 + 22 * x3 >= 18)
    model.addConstr(19 * x0 + 13 * x1 + 7 * x2 + 22 * x3 >= 18)
    model.addConstr(x0**2 + x2**2 <= 165)
    model.addConstr(6 * x1**2 + 11 * x2**2 + 6 * x3**2 <= 178)
    model.addConstr(23 * x0 + 11 * x1 + 16 * x3 <= 137)
    model.addConstr(23 * x0**2 + 5 * x2**2 + 22 * x3**2 <= 88)
    model.addConstr(22 * x0 + 2 * x3 <= 121)
    model.addConstr(14 * x2 + 2 * x3 <= 144)
    model.addConstr(5 * x1**2 + 2 * x3**2 <= 170)
    model.addConstr(19 * x0**2 + 13 * x1**2 + 22 * x3**2 <= 90)
    model.addConstr(13 * x1**2 + 7 * x2**2 + 22 * x3**2 <= 55)
    model.addConstr(19 * x0 + 13 * x1 + 7 * x2 <= 146)
    model.addConstr(19 * x0 + 7 * x2 + 22 * x3 <= 129)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print("Hours worked by Hank: ", x0.varValue)
        print("Hours worked by Dale: ", x1.varValue)
        print("Hours worked by Jean: ", x2.varValue)
        print("Hours worked by George: ", x3.varValue)
    else:
        print("No optimal solution found.")

optimize_problem()
