
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
fiber = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fiber")
vitamin_b4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b4")
fat = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fat")
vitamin_a = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_a")
vitamin_b9 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b9")
zinc = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="zinc")


# Set objective function
m.setObjective(5.81 * fiber + 5.03 * vitamin_b4 + 5.98 * fat + 5.46 * vitamin_a + 7.33 * vitamin_b9 + 4.03 * zinc, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * vitamin_b4 + 10 * vitamin_b9 >= 25)
m.addConstr(9 * fiber + 5 * vitamin_b4 >= 24)
m.addConstr(10 * vitamin_b9 + 2 * zinc >= 13)
m.addConstr(5 * vitamin_b4 + 14 * vitamin_a + 2 * zinc >= 35)
m.addConstr(9 * fiber + 14 * vitamin_a + 2 * zinc >= 35)
m.addConstr(9 * fiber + 5 * vitamin_b4 + 8 * fat >= 35)
m.addConstr(9 * fiber + 8 * fat + 2 * zinc >= 35)
m.addConstr(5 * vitamin_b4 + 14 * vitamin_a + 2 * zinc >= 26)
m.addConstr(9 * fiber + 14 * vitamin_a + 2 * zinc >= 26)
m.addConstr(9 * fiber + 5 * vitamin_b4 + 8 * fat >= 26)
m.addConstr(9 * fiber + 8 * fat + 2 * zinc >= 26)
m.addConstr(5 * vitamin_b4 + 14 * vitamin_a + 2 * zinc >= 25)
m.addConstr(9 * fiber + 14 * vitamin_a + 2 * zinc >= 25)
m.addConstr(9 * fiber + 5 * vitamin_b4 + 8 * fat >= 25)
m.addConstr(9 * fiber + 8 * fat + 2 * zinc >= 25)
m.addConstr(5 * vitamin_b4 + 14 * vitamin_a + 2 * zinc >= 30)
m.addConstr(9 * fiber + 14 * vitamin_a + 2 * zinc >= 30)
m.addConstr(9 * fiber + 5 * vitamin_b4 + 8 * fat >= 30)
m.addConstr(9 * fiber + 8 * fat + 2 * zinc >= 30)
m.addConstr(9 * fiber + 5 * vitamin_b4 + 8 * fat + 14 * vitamin_a + 10 * vitamin_b9 + 2 * zinc >= 30)
m.addConstr(-8 * fat + 3 * zinc >= 0)
m.addConstr(10 * fat - 5 * vitamin_b9 >= 0)
m.addConstr(7 * vitamin_b4 - zinc >= 0)
m.addConstr(-7 * fiber + 5 * zinc >= 0)
m.addConstr(-9 * fiber + vitamin_b4 >= 0)
m.addConstr(-6 * vitamin_b4 - 6 * vitamin_b9 + 6 * zinc >= 0)
m.addConstr(9 * fiber + 5 * vitamin_b4 + 2 * zinc <= 167)
m.addConstr(9 * fiber + 5 * vitamin_b4 + 8 * fat + 14 * vitamin_a + 10 * vitamin_b9 + 2 * zinc <= 230)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

