
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0)  # grams of fiber
    x2 = model.addVar(name="x2", lb=0)  # milligrams of vitamin B4
    x3 = model.addVar(name="x3", lb=0)  # grams of fat
    x4 = model.addVar(name="x4", lb=0)  # milligrams of vitamin A
    x5 = model.addVar(name="x5", lb=0)  # milligrams of vitamin B9
    x6 = model.addVar(name="x6", lb=0)  # milligrams of zinc

    # Objective function
    model.setObjective(5.81 * x1 + 5.03 * x2 + 5.98 * x3 + 5.46 * x4 + 7.33 * x5 + 4.03 * x6, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(9 * x1 <= 230)
    model.addConstr(5 * x2 <= 230)
    model.addConstr(8 * x3 <= 230)
    model.addConstr(14 * x4 <= 230)
    model.addConstr(10 * x5 <= 230)
    model.addConstr(2 * x6 <= 230)

    model.addConstr(5 * x2 + 10 * x5 >= 25)
    model.addConstr(9 * x1 + 5 * x2 >= 24)
    model.addConstr(10 * x5 + 2 * x6 >= 13)
    model.addConstr(5 * x2 + 14 * x4 + 2 * x6 >= 35)
    model.addConstr(9 * x1 + 14 * x4 + 2 * x6 >= 35)
    model.addConstr(9 * x1 + 5 * x2 + 8 * x3 >= 35)
    model.addConstr(9 * x1 + 8 * x3 + 2 * x6 >= 35)

    model.addConstr(5 * x2 + 14 * x4 + 2 * x6 >= 26)
    model.addConstr(9 * x1 + 14 * x4 + 2 * x6 >= 26)
    model.addConstr(9 * x1 + 5 * x2 + 8 * x3 >= 26)
    model.addConstr(9 * x1 + 8 * x3 + 2 * x6 >= 26)

    model.addConstr(5 * x2 + 14 * x4 + 2 * x6 >= 25)
    model.addConstr(9 * x1 + 14 * x4 + 2 * x6 >= 25)
    model.addConstr(9 * x1 + 5 * x2 + 8 * x3 >= 25)
    model.addConstr(9 * x1 + 8 * x3 + 2 * x6 >= 25)

    model.addConstr(5 * x2 + 14 * x4 + 2 * x6 >= 30)
    model.addConstr(9 * x1 + 14 * x4 + 2 * x6 >= 30)
    model.addConstr(9 * x1 + 5 * x2 + 8 * x3 >= 30)
    model.addConstr(9 * x1 + 8 * x3 + 2 * x6 >= 30)

    model.addConstr(9 * x1 + 5 * x2 + 8 * x3 + 14 * x4 + 10 * x5 + 2 * x6 >= 30)

    model.addConstr(-8 * x3 + 3 * x6 >= 0)
    model.addConstr(10 * x3 - 5 * x5 >= 0)
    model.addConstr(7 * x2 - x6 >= 0)
    model.addConstr(-7 * x1 + 5 * x6 >= 0)
    model.addConstr(-9 * x1 + x2 >= 0)
    model.addConstr(-6 * x2 - 6 * x5 + 6 * x6 >= 0)

    model.addConstr(9 * x1 + 5 * x2 + 2 * x6 <= 167)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
        print("x4: ", x4.varValue)
        print("x5: ", x5.varValue)
        print("x6: ", x6.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
