
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
hank = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank")
george = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="george")
bill = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill")
dale = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale")
paul = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul")


# Set objective function
m.setObjective(7.25*hank**2 + 7.27*hank*dale + 7.69*george*bill + 8.91*george*paul + 7.61*paul**2 + 7.84*hank + 6.05*bill + 6.3*dale, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9*george**2 + 1*dale**2 >= 32)
m.addConstr(3*hank + 20*paul >= 27)
m.addConstr(14*bill + 1*dale >= 21)
m.addConstr(9*george + 14*bill >= 28)
m.addConstr(3*hank**2 + 14*bill**2 + 1*dale**2 >= 22)
m.addConstr(3*hank**2 + 1*dale**2 + 20*paul**2 >= 22)
m.addConstr(3*hank + 14*bill + 20*paul >= 22)
m.addConstr(9*george + 14*bill + 20*paul >= 22)
m.addConstr(3*hank + 14*bill + 1*dale >= 28)
m.addConstr(3*hank + 1*dale + 20*paul >= 28)
m.addConstr(3*hank + 14*bill + 20*paul >= 28)
m.addConstr(9*george + 14*bill + 20*paul >= 28)
m.addConstr(3*hank**2 + 14*bill**2 + 1*dale**2 >= 32)
m.addConstr(3*hank + 1*dale + 20*paul >= 32)
m.addConstr(3*hank**2 + 14*bill**2 + 20*paul**2 >= 32)
m.addConstr(9*george + 14*bill + 20*paul >= 32)
m.addConstr(3*hank + 14*bill + 1*dale >= 18)
m.addConstr(3*hank + 1*dale + 20*paul >= 18)
m.addConstr(3*hank + 14*bill + 20*paul >= 18)
m.addConstr(9*george**2 + 14*bill**2 + 20*paul**2 >= 18)
m.addConstr(3*hank + 9*george + 14*bill + 1*dale + 20*paul >= 18)
# ... (rest of the constraints)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("Optimization terminated with status:", m.status)

