
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=0, name="x0")
    x1 = model.addVar(lb=0, name="x1")
    x2 = model.addVar(lb=0, name="x2")
    x3 = model.addVar(lb=0, name="x3")
    x4 = model.addVar(lb=0, name="x4")

    # Objective function
    model.setObjective(7.25*x0**2 + 7.27*x0*x3 + 7.69*x1*x2 + 8.91*x1*x4 + 7.61*x4**2 + 7.84*x0 + 6.05*x2 + 6.3*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(3*x0 <= 160)
    model.addConstr(17*x0 <= 202)
    model.addConstr(3*x0 <= 242)
    model.addConstr(9*x1 <= 160)
    model.addConstr(13*x1 <= 202)
    model.addConstr(7*x1 <= 242)
    model.addConstr(14*x2 <= 160)
    model.addConstr(2*x2 <= 202)
    model.addConstr(20*x2 <= 242)
    model.addConstr(1*x3 <= 160)
    model.addConstr(3*x3 <= 202)
    model.addConstr(7*x3 <= 242)
    model.addConstr(20*x4 <= 160)
    model.addConstr(15*x4 <= 202)
    model.addConstr(20*x4 <= 242)

    model.addConstr(9*x1**2 + 1*x3**2 >= 32)
    model.addConstr(3*x0 + 20*x4 >= 27)
    model.addConstr(14*x2 + 1*x3 >= 21)
    model.addConstr(9*x1 + 14*x2 >= 28)
    model.addConstr(3*x0**2 + 14*x2**2 + 1*x3**2 >= 22)
    model.addConstr(3*x0**2 + 1*x3**2 + 20*x4**2 >= 22)
    model.addConstr(3*x0 + 14*x2 + 20*x4 >= 22)
    model.addConstr(9*x1 + 14*x2 + 20*x4 >= 22)
    model.addConstr(3*x0 + 1*x3 + 20*x4 >= 28)
    model.addConstr(3*x0 + 14*x2 + 20*x4 >= 28)

    # ... add all constraints

    model.addConstr(4*x0 - 2*x1 >= 0)
    model.addConstr(9*x0 - 9*x2 >= 0)
    model.addConstr(9*x1**2 + 14*x2**2 + 1*x3**2 <= 113)
    model.addConstr(3*x0 + 14*x2 + 1*x3 <= 66)
    model.addConstr(3*x0**2 + 14*x2**2 + 20*x4**2 <= 135)
    model.addConstr(9*x1**2 + 14*x2**2 + 20*x4**2 <= 65)
    model.addConstr(3*x0 + 9*x1 + 14*x2 <= 79)
    model.addConstr(3*x0 + 9*x1 + 1*x3 <= 63)
    model.addConstr(9*x1**2 + 1*x3**2 + 20*x4**2 <= 98)
    model.addConstr(17*x0 + 13*x1 <= 125)
    model.addConstr(17*x0 + 2*x2 <= 179)
    model.addConstr(3*x0 + 1*x3 + 20*x4 <= 193)
    model.addConstr(3*x0 + 9*x1 + 14*x2 <= 136)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print("x0:", x0.varValue)
        print("x1:", x1.varValue)
        print("x2:", x2.varValue)
        print("x3:", x3.varValue)
        print("x4:", x4.varValue)
        print("Objective:", model.objVal)
    else:
        print("No optimal solution found.")

solve_optimization_problem()
