
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("resource_allocation")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="mechanized_infantry_companies")
    x1 = model.addVar(vtype=gp.GRB.INTEGER, name="logistics_companies")


    # Set objective function
    model.setObjective(4.6 * x0 + 8.11 * x1, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(5 * x0 + 6 * x1 >= 17, "mobility_lower_bound")
    model.addConstr(1 * x0 + 10 * x1 >= 21, "defense_lower_bound")
    model.addConstr(6 * x0 + 9 * x1 >= 20, "logistics_lower_bound")
    model.addConstr(2 * x0 + 4 * x1 >= 19, "fun_lower_bound")
    model.addConstr(-3 * x0 + 10 * x1 >= 0, "custom_constraint")

    model.addConstr(5 * x0 + 6 * x1 <= 64, "mobility_upper_bound")
    model.addConstr(1 * x0 + 10 * x1 <= 79, "defense_upper_bound")
    model.addConstr(6 * x0 + 9 * x1 <= 36, "logistics_upper_bound")
    model.addConstr(2 * x0 + 4 * x1 <= 64, "fun_upper_bound")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal solution found:")
        print(f"Mechanized Infantry Companies: {x0.x}")
        print(f"Logistics Companies: {x1.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Gurobi error: {e}")

except AttributeError:
    print("Encountered an attribute error. Check variable names and model status.")

