
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="mechanized_infantry_companies", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="logistics_companies", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(4.6 * x0 + 8.11 * x1, gp.GRB.MINIMIZE)

# Define the constraints
m.addConstr(5 * x0 + 6 * x1 >= 17, name="mobility_rating")
m.addConstr(x0 + 10 * x1 >= 21, name="defensive_capability_rating")
m.addConstr(6 * x0 + 9 * x1 >= 20, name="logistical_capacity")
m.addConstr(2 * x0 + 4 * x1 >= 19, name="fun_factor")
m.addConstr(-3 * x0 + 10 * x1 >= 0, name="mixed_constraint_1")
m.addConstr(5 * x0 + 6 * x1 <= 64, name="mobility_rating_upper")
m.addConstr(x0 + 10 * x1 <= 79, name="defensive_capability_rating_upper")
m.addConstr(6 * x0 + 9 * x1 <= 36, name="logistical_capacity_upper")
m.addConstr(2 * x0 + 4 * x1 <= 64, name="fun_factor_upper")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Mechanized Infantry Companies: ", x0.varValue)
    print("Logistics Companies: ", x1.varValue)
else:
    print("The model is infeasible")
