
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("resource_allocation")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_Paul")
    x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_Hank")


    # Set objective function
    model.setObjective(6*x0 + 4*x1, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(13*x0 + 3*x1 >= 8, "organization_score_min")
    model.addConstr(6*x0 + 14*x1 >= 29, "likelihood_to_quit_min")
    model.addConstr(6*x0 + 13*x1 >= 7, "dollar_cost_min")
    model.addConstr(11*x0 + 11*x1 >= 17, "paperwork_rating_min")
    model.addConstr(4*x0 - 7*x1 >= 0, "custom_constraint")
    model.addConstr(13*x0 + 3*x1 <= 42, "organization_score_max")
    model.addConstr(6*x0 + 14*x1 <= 42, "likelihood_to_quit_max")
    model.addConstr(6*x0 + 13*x1 <= 38, "dollar_cost_max")
    model.addConstr(11*x0 + 11*x1 <= 20, "paperwork_rating_max")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('hours worked by Paul:', x0.x)
        print('hours worked by Hank:', x1.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
