
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_Paul")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_Hank")

# Set the objective function
m.setObjective(6*x0 + 4*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(13*x0 + 3*x1 >= 8, "organization_score_min")
m.addConstr(6*x0 + 14*x1 >= 29, "quit_index_min")
m.addConstr(6*x0 + 13*x1 >= 7, "dollar_cost_per_hour_min")
m.addConstr(11*x0 + 11*x1 >= 17, "paperwork_competence_rating_min")
m.addConstr(4*x0 - 7*x1 >= 0, "mixed_constraint")
m.addConstr(13*x0 + 3*x1 <= 42, "organization_score_max")
m.addConstr(6*x0 + 14*x1 <= 42, "quit_index_max")
m.addConstr(6*x0 + 13*x1 <= 38, "dollar_cost_per_hour_max")
m.addConstr(11*x0 + 11*x1 <= 20, "paperwork_competence_rating_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Paul: {x0.x}")
    print(f"Hours worked by Hank: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
