
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="hours_worked_by_Paul", lb=0)  # hours worked by Paul
    x1 = model.addVar(name="hours_worked_by_Hank", lb=0)  # hours worked by Hank

    # Define the objective function
    model.setObjective(6 * x0 + 4 * x1, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(13 * x0 + 3 * x1 >= 8, name="organization_score")
    model.addConstr(6 * x0 + 14 * x1 >= 29, name="likelihood_to_quit_index")
    model.addConstr(6 * x0 + 13 * x1 >= 7, name="dollar_cost_per_hour")
    model.addConstr(11 * x0 + 11 * x1 >= 17, name="paperwork_competence_rating")
    model.addConstr(4 * x0 - 7 * x1 >= 0, name="ratio_constraint")
    model.addConstr(13 * x0 + 3 * x1 <= 42, name="organization_score_upper_bound")
    model.addConstr(6 * x0 + 14 * x1 <= 42, name="likelihood_to_quit_index_upper_bound")
    model.addConstr(6 * x0 + 13 * x1 <= 38, name="dollar_cost_per_hour_upper_bound")
    model.addConstr(11 * x0 + 11 * x1 <= 20, name="paperwork_competence_rating_upper_bound")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Paul: {x0.varValue}")
        print(f"Hours worked by Hank: {x1.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
