
import gurobipy as gp

# Create a new model
m = gp.Model("minimize_cost")

# Create variables
boxwoods = m.addVar(vtype=gp.GRB.INTEGER, name="boxwoods")
lilies = m.addVar(vtype=gp.GRB.INTEGER, name="lilies")

# Set objective function
m.setObjective(9.81 * boxwoods + 3.17 * lilies, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * boxwoods + 1 * lilies >= 31, "min_cost")
m.addConstr(5 * boxwoods + 1 * lilies <= 46, "max_cost")
m.addConstr(7 * boxwoods + 7 * lilies >= 9, "min_water")
m.addConstr(7 * boxwoods + 7 * lilies <= 35, "max_water")
m.addConstr(7 * boxwoods - 2 * lilies >= 0, "boxwood_lily_ratio")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal solution:")
    print(f"Boxwoods: {boxwoods.x}")
    print(f"Lilies: {lilies.x}")
    print(f"Objective value: {m.objVal}")

