
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="boxwoods")
x1 = m.addVar(vtype=GRB.INTEGER, name="lilies")

# Objective function: Minimize the total cost
m.setObjective(9.81*x0 + 3.17*x1, GRB.MINIMIZE)

# Constraints
m.addConstr(5*x0 + x1 >= 31, "dollar_cost_lower_bound")
m.addConstr(7*x0 + 7*x1 >= 9, "water_need_lower_bound")
m.addConstr(7*x0 - 2*x1 >= 0, "linear_constraint")
m.addConstr(5*x0 + x1 <= 46, "dollar_cost_upper_bound")
m.addConstr(7*x0 + 7*x1 <= 35, "water_need_upper_bound")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Boxwoods: {x0.x}")
    print(f"Lilies: {x1.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
