
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    boxwoods = model.addVar(name="boxwoods", vtype=gurobi.GRB.INTEGER)
    lilies = model.addVar(name="lilies", vtype=gurobi.GRB.INTEGER)

    # Objective function: minimize 9.81 * boxwoods + 3.17 * lilies
    model.setObjective(9.81 * boxwoods + 3.17 * lilies, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(5 * boxwoods + lilies >= 31, name="cost_min")
    model.addConstr(5 * boxwoods + lilies <= 65, name="cost_max")
    model.addConstr(7 * boxwoods + 7 * lilies >= 9, name="water_min")
    model.addConstr(7 * boxwoods + 7 * lilies <= 38, name="water_max")
    model.addConstr(7 * boxwoods - 2 * lilies >= 0, name="boxwoods_vs_lilies")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Boxwoods: {boxwoods.varValue}")
        print(f"Lilies: {lilies.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
