
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    apple_pies = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="apple_pies")
    protein_bars = m.addVar(lb=0, vtype=GRB.INTEGER, name="protein_bars")
    ramen = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bowls_of_instant_ramen")


    # Set objective function
    m.setObjective(1.21*apple_pies**2 + 2.36*apple_pies*protein_bars + 7.88*apple_pies + 2.72*ramen, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(protein_bars + 19*ramen >= 86, "c0")
    m.addConstr(apple_pies**2 + protein_bars**2 + ramen**2 >= 45, "c1")
    m.addConstr(18*protein_bars + 14*ramen >= 99, "c2")
    m.addConstr(10*apple_pies**2 + 14*ramen**2 >= 97, "c3")
    m.addConstr(10*apple_pies**2 + 18*protein_bars**2 >= 114, "c4")
    m.addConstr(apple_pies**2 + 19*protein_bars**2 <= 200, "c5")
    m.addConstr(apple_pies**2 + 19*ramen**2 <= 168, "c6")
    m.addConstr(19*protein_bars + 19*ramen <= 188, "c7")
    m.addConstr(apple_pies + 19*protein_bars + 19*ramen <= 188, "c8")
    m.addConstr(18*protein_bars**2 + 14*ramen**2 <= 291, "c9")
    m.addConstr(10*apple_pies**2 + 18*protein_bars**2 <= 277, "c10")
    m.addConstr(10*apple_pies + 18*protein_bars + 14*ramen <= 277, "c11")
    m.addConstr(apple_pies + 19*protein_bars + 19*ramen <= 275, "c12")
    m.addConstr(10*apple_pies + 18*protein_bars + 14*ramen <= 391, "c13")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
