
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="apple_pies", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x1 = m.addVar(name="protein_bars", lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="bowls_of_instant_ramen", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)

# Define the objective function
m.setObjective(1.21*x0**2 + 2.36*x0*x1 + 7.88*x0 + 2.72*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x0 <= 275)  # umami index of apple pies
m.addConstr(10*x0 <= 391)  # grams of fat from apple pies
m.addConstr(19*x1 + 19*x2 >= 86)  # total umami index from protein bars and bowls of instant ramen
m.addConstr(x0**2 + 19*x1**2 + 19*x2**2 >= 45)  # total combined umami index squared
m.addConstr(18*x1 + 14*x2 >= 99)  # total grams of fat from protein bars and bowls of instant ramen
m.addConstr(10*x0**2 + 14*x2**2 >= 97)  # grams of fat from apple pies squared and bowls of instant ramen squared
m.addConstr(10*x0**2 + 18*x1**2 >= 114)  # grams of fat from apple pies squared and protein bars squared
m.addConstr(x0**2 + 19*x1**2 <= 200)  # total umami index from apple pies squared and protein bars squared
m.addConstr(x0**2 + 19*x2**2 <= 168)  # total umami index from apple pies squared and bowls of instant ramen squared
m.addConstr(19*x1 + 19*x2 <= 188)  # total umami index from protein bars and bowls of instant ramen
m.addConstr(x0 + 19*x1 + 19*x2 <= 188)  # total umami index from all
m.addConstr(18*x1**2 + 14*x2**2 <= 291)  # grams of fat from protein bars squared and bowls of instant ramen squared
m.addConstr(10*x0**2 + 18*x1**2 <= 277)  # grams of fat from apple pies squared and protein bars squared
m.addConstr(10*x0 + 18*x1 + 14*x2 <= 277)  # total grams of fat from all

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Apple Pies: ", x0.varValue)
    print("Protein Bars: ", x1.varValue)
    print("Bowls of Instant Ramen: ", x2.varValue)
else:
    print("The model is infeasible")
