
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    corn_cobs = m.addVar(vtype=gp.GRB.CONTINUOUS, name="corn_cobs")
    cherry_pies = m.addVar(vtype=gp.GRB.INTEGER, name="cherry_pies")

    # Set objective function
    m.setObjective(7.91 * corn_cobs + 4.62 * cherry_pies, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(20 * corn_cobs + 16 * cherry_pies >= 56, "fat_lower_bound")
    m.addConstr(15 * corn_cobs + 16 * cherry_pies >= 39, "sourness_lower_bound")
    m.addConstr(16 * corn_cobs + 15 * cherry_pies >= 25, "calcium_lower_bound")
    m.addConstr(-3 * corn_cobs + 9 * cherry_pies >= 0, "constraint_4")
    m.addConstr(20 * corn_cobs + 16 * cherry_pies <= 101, "fat_upper_bound")
    m.addConstr(15 * corn_cobs + 16 * cherry_pies <= 47, "sourness_upper_bound")
    m.addConstr(16 * corn_cobs + 15 * cherry_pies <= 97, "calcium_upper_bound")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('corn_cobs:', corn_cobs.x)
        print('cherry_pies:', cherry_pies.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)

except gp.GrorbiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

