
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="corn_cobs")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="cherry_pies")

# Set the objective function
m.setObjective(7.91*x1 + 4.62*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 16*x2 >= 56, "fat_min")
m.addConstr(20*x1 + 16*x2 <= 101, "fat_max")
m.addConstr(15*x1 + 16*x2 >= 39, "sourness_min")
m.addConstr(15*x1 + 16*x2 <= 47, "sourness_max")
m.addConstr(16*x1 + 15*x2 >= 25, "calcium_min")
m.addConstr(16*x1 + 15*x2 <= 97, "calcium_max")
m.addConstr(-3*x1 + 9*x2 >= 0, "additional_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"corn_cobs: {x1.x}, cherry_pies: {x2.x}")
else:
    print("No optimal solution found.")

