
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="corn_cobs", lb=0)  # Non-integer number of corn cobs
    x2 = model.addVar(name="cherry_pies", lb=0, integrality=1)  # Whole number of cherry pies

    # Define the objective function
    model.setObjective(7.91 * x1 + 4.62 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(20 * x1 + 16 * x2 >= 56)  # at least 56 grams of fat
    model.addConstr(15 * x1 + 16 * x2 >= 39)  # total sourness index at least 39
    model.addConstr(16 * x1 + 15 * x2 >= 25)  # at least 25 milligrams of calcium
    model.addConstr(-3 * x1 + 9 * x2 >= 0)  # linear constraint
    model.addConstr(20 * x1 + 16 * x2 <= 101)  # up to 101 grams of fat
    model.addConstr(15 * x1 + 16 * x2 <= 47)  # total sourness index at most 47
    model.addConstr(16 * x1 + 15 * x2 <= 97)  # up to 97 milligrams of calcium

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Corn cobs: {x1.varValue}")
        print(f"Cherry pies: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
