
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
green_beans = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="green_beans")
ham_sandwiches = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ham_sandwiches")
cornichons = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cornichons")

# Set objective function
m.setObjective(1.24 * green_beans + 3.93 * ham_sandwiches + 1.9 * cornichons, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(6 * green_beans + 15 * ham_sandwiches + 4 * cornichons <= 143, "dollar_cost")
m.addConstr(10 * green_beans + 16 * ham_sandwiches + 1 * cornichons <= 131, "fiber")
m.addConstr(6 * green_beans + 15 * ham_sandwiches >= 42, "min_gb_hs_cost")
m.addConstr(15 * ham_sandwiches + 4 * cornichons >= 33, "min_hs_c_cost")
m.addConstr(6 * green_beans + 15 * ham_sandwiches + 4 * cornichons >= 34, "min_total_cost")
m.addConstr(6 * green_beans + 15 * ham_sandwiches <= 72, "max_gb_hs_cost")
m.addConstr(6 * green_beans + 15 * ham_sandwiches + 4 * cornichons <= 72, "max_total_cost")
m.addConstr(16 * ham_sandwiches + 1 * cornichons <= 122, "max_hs_c_fiber")
m.addConstr(10 * green_beans + 16 * ham_sandwiches <= 70, "max_gb_hs_fiber")
m.addConstr(10 * green_beans + 16 * ham_sandwiches + 1 * cornichons <= 70, "max_total_fiber")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('green_beans:', green_beans.x)
    print('ham_sandwiches:', ham_sandwiches.x)
    print('cornichons:', cornichons.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

