
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="green_beans", lb=0)  # green beans
    x1 = model.addVar(name="ham_sandwiches", lb=0)  # ham sandwiches
    x2 = model.addVar(name="cornichons", lb=0)  # cornichons

    # Objective function
    model.setObjective(1.24 * x0 + 3.93 * x1 + 1.9 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(6 * x0 + 15 * x1 + 4 * x2 <= 143)  # total cost
    model.addConstr(6 * x0 + 15 * x1 >= 42)  # min spend on green beans and ham
    model.addConstr(15 * x1 + 4 * x2 >= 33)  # min spend on ham and cornichons
    model.addConstr(6 * x0 + 15 * x1 + 4 * x2 >= 34)  # min total spend
    model.addConstr(6 * x0 + 15 * x1 <= 72)  # max spend on green beans and ham
    model.addConstr(10 * x0 + 16 * x1 + x2 <= 131)  # total fiber
    model.addConstr(16 * x1 + x2 <= 122)  # fiber from ham and cornichons
    model.addConstr(10 * x0 + 16 * x1 <= 70)  # fiber from green beans and ham
    model.addConstr(10 * x0 + 16 * x1 + x2 <= 70)  # total fiber from all

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Green beans: ", x0.varValue)
        print("Ham sandwiches: ", x1.varValue)
        print("Cornichons: ", x2.varValue)
    else:
        print("No solution found")

solve_optimization_problem()
