
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin B1
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of vitamin B12


    # Set objective function
    m.setObjective(9.48 * x0 + 7.02 * x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(5 * x0 + 6 * x1 >= 38, "c0")
    m.addConstr(-3 * x0 + 5 * x1 >= 0, "c1")
    m.addConstr(5 * x0 + 6 * x1 <= 82, "c2")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print(f"Optimal objective value: {m.objVal}")
        print(f"milligrams of vitamin B1 (x0): {x0.x}")
        print(f"milligrams of vitamin B12 (x1): {x1.x}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
