
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Define the variables
x1 = m.addVar(lb=0, name="milligrams_of_vitamin_B1")
x2 = m.addVar(lb=0, name="milligrams_of_vitamin_B12")

# Set the objective function
m.setObjective(9.48*x1 + 7.02*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 6*x2 >= 38, "cardiovascular_support_index_lower_bound")
m.addConstr(-3*x1 + 5*x2 >= 0, "inequality_constraint")
m.addConstr(5*x1 + 6*x2 <= 82, "cardiovascular_support_index_upper_bound")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B1: {x1.x}")
    print(f"Milligrams of Vitamin B12: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
