
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='milligrams_of_vitamin_B1', lb=0)  # lower bound is 0, as it represents a quantity
    x2 = model.addVar(name='milligrams_of_vitamin_B12', lb=0)  # lower bound is 0, as it represents a quantity

    # Define the objective function
    model.setObjective(9.48 * x1 + 7.02 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(5 * x1 + 6 * x2 >= 38)
    model.addConstr(-3 * x1 + 5 * x2 >= 0)
    model.addConstr(5 * x1 + 6 * x2 <= 82)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'milligrams of vitamin B1: {x1.varValue}')
        print(f'milligrams of vitamin B12: {x2.varValue}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
