
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # hours worked by Jean
    x1 = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x1") # hours worked by Bill


    # Set objective function
    model.setObjective(3*x0**2 + 4*x1**2 + x0, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(18*x0 + 23*x1 >= 75, "c1")
    model.addConstr(12*x0 + 11*x1 >= 62, "c2")
    model.addConstr(12*x0**2 + 11*x1**2 >= 62, "c3")
    model.addConstr(4*x0 - 8*x1 >= 0, "c4")
    model.addConstr(18*x0 + 23*x1 <= 89, "c5")
    model.addConstr(12*x0 + 11*x1 <= 124, "c6")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal solution found:")
        print(f"x0 (hours worked by Jean): {x0.x}")
        print(f"x1 (hours worked by Bill): {x1.x}")
        print(f"Objective value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print("Encountered an attribute error")

