
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(lb=0, name="hours_worked_by_Jean")  # non-negative real
x2 = model.addVar(lb=0, type=gurobi.GRB.INTEGER, name="hours_worked_by_Bill")  # non-negative integer

# Set the objective function
model.setObjective(3*x1**2 + 4*x2**2 + x1, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(18*x1 + 23*x2 >= 75, name="computer_competence_rating_min")
model.addConstr(12*x1**2 + 11*x2**2 >= 62, name="dollar_cost_per_hour_min")
model.addConstr(12*x1 + 11*x2 >= 62, name="dollar_cost_per_hour_min_linear")
model.addConstr(4*x1 - 8*x2 >= 0, name="jean_bill_hours_constraint")
model.addConstr(18*x1 + 23*x2 <= 89, name="computer_competence_rating_max")
model.addConstr(12*x1 + 11*x2 <= 124, name="dollar_cost_per_hour_max")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Jean: {x1.varValue}")
    print(f"Hours worked by Bill: {x2.varValue}")
else:
    print("No optimal solution found.")
