
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin B9
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of vitamin B4
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # grams of fiber
    x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x3") # milligrams of vitamin K


    # Set objective function
    m.setObjective(7*x0 + 8*x1 + 7*x2 + 5*x3, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(11*x0 + 9*x1 + 11*x2 + 3*x3 <= 79, "c0") # kidney support index
    m.addConstr(-8*x1 + x2 >= 0, "c1")
    m.addConstr(9*x1 + 3*x3 <= 64, "c2")
    m.addConstr(11*x0 + 9*x1 <= 75, "c3")
    m.addConstr(11*x0 + 11*x2 <= 49, "c4")
    m.addConstr(11*x2 + 3*x3 <= 45, "c5")
    m.addConstr(11*x0 + 3*x3 <= 30, "c6")
    m.addConstr(11*x0 + 9*x1 + 11*x2 + 3*x3 <= 30, "c7")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
